<?php
/****************************************
 * XKLog 后台管理页
 *
 * 此文件控制输出后台管理页
 *
 * 更新：2009-06-23
 * 版本：V1.0
 ****************************************/

require('../include/loader.php');
@header("content-Type: text/html; charset=utf-8");

if( !user_is_super_admin() ){
	//SafeLogger("试图直接访问后台页面 admin_comment.php 。")
	//SafeDefender()
	show_admin_message( '您尚未登录，或者登录已过期' );
	exit;
}

$action = getGP( 'action', 'G' );

switch( $action ) {
    case 'Del':
    	del_comment();
    	break;
    case 'OK':
    	censor_comment();
    	break;
    case 'BatchExe':
    	batch_exe();
    	break;
}

function censor_comment() {
	global $db;
	$id = getGP( 'id', 'G', 'int' );
	$db->query( "UPDATE `" . PREFIX_STR . "Comment` SET IsShow = 1 WHERE CID = $id" );
	cache_comment_new();
	cache_guestbook_new();
	show_admin_message( '审核评论成功', 'admin_comment.php?action=Censor' );
	exit;
}

function del_comment() {
	global $db;
	$id = getGP( 'id', 'G', 'int' );
	$aid = $db->result( "SELECT ArticleID FROM `" . PREFIX_STR . "Comment` WHERE CID=$id AND IsDel = 0" );
	if( $aid == '' ) {
		show_admin_message( '评论不存在！' );
		exit;
	}
	$db->query( "UPDATE `" . PREFIX_STR . "Article` SET Comment = Comment - 1 WHERE ID=$aid" );
	$db->query( "UPDATE `" . PREFIX_STR . "Comment` SET IsDel = 1 WHERE CID=$id" );
	cache_article_hot();
	cache_comment_new();
	cache_guestbook_new();
	cache_count();
	show_admin_message( '删除评论成功', 'admin_comment.php?action=Comment' );
	exit;
}

function batch_exe() {
	show_admin_message( '抱歉，此功能尚未完成', 'admin_comment.php' );
	exit;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title><?php echo $_CACHE['set'][0]['BlogName'] ?> - 后台管理</title>
	<link rel = "stylesheet" type = "text/css" href = "../Include/Style.css" />
	<script language="javascript" type="text/javascript" src="../Include/admin.js"></script>
</head>
<body id = "Admin_Body">
<div id = "Admin_Main">
<center>
	<div class = "Admin_Panel">
		<div class = "Admin_Title">留言与评论管理</div>
		<div class = "Admin_Content">
			<div style="padding:5px;margin:2px;border:1px solid #96C2F1;background-color: #EFF7FF;"><a href="admin_comment.php?action=Comment">评论管理</a> | <a href="admin_comment.php?action=Censor">评论审核</a></div>
<?php

switch( $action ) {
    case 'Comment':
        comment_list();
    	break;
    case 'Censor':
        comment_list( 'censor' );
    	break;
    case 'Batch':
    	batch();
    	break;
	default:
		main();
}

function comment_list( $action = 'list' ) {
	global $db,$_CACHE;
	if( $action == 'list' ) {
		$sql = 'select CID,Author,Time,Comment,Reply,ReplyTime from `' . PREFIX_STR . 'Comment` where IsDel=0 And IsShow<>0 order by CID desc';
	}else{
		$sql = 'select CID,Author,Time,Comment,Reply,ReplyTime from `' . PREFIX_STR . 'Comment` where IsDel=0 And IsShow=0 order by CID desc';
	}
	$comment_array = $db->fetch_all( $sql );
?>
			<form name="smslist" action="admin_comment.php?action=Batch" method="post">
				<div style="padding:5px;margin:2px;">      
					<table class="pickme" style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
						<thead>
							<tr align="center" height="22" bgcolor="#ffffff">
								<td width="3%"  background="../Include/bg.gif"><input type="checkbox" name="allbox" onclick="CheckAll();"><input type="checkbox" id="ckbox" style="display:none;" disabled></td>
								<td width="3%"  background="../Include/bg.gif">序号</td>
								<td width="10%" background="../Include/bg.gif">作者</td>
								<td width="31%" background="../Include/bg.gif">内容</td>
								<td width="9%" background="../Include/bg.gif">时间</td>
								<td width="22%" background="../Include/bg.gif">回复</td>
								<td width="9%" background="../Include/bg.gif">回复时间</td>
								<td width="13%" background="../Include/bg.gif">管理操作</td>
							</tr>
						</thead>
						<tbody>
							<?php
							$i = 1;
							foreach( $comment_array as $value ) {
							?>
							<tr align="center" height="20" bgcolor="#ffffff">
								<td ><input type="checkbox" id="ckbox" name="id_arr[]" value="<?php echo $value['CID'] ?>" /></td>
								<td><?php echo $i ?></td>
								<td><?php echo $value['Author'] ?></td>
								<td align="left"><?php echo $value['Comment'] ?></td>
								<td><?php echo date( 'Y-m-d', $value['Time'] ) ?></td>
								<td align="left"><?php echo $value['Reply'] ?></td>
								<td><?php if( $value['Reply'] != '' ) echo date( 'Y-m-d', $value['ReplyTime'] ); ?></td>
								<td>
								<?php if( $action == 'list' ) { ?>
									<span class="Control"><img src="../Include/del.gif" width="16" height="16" /><a href="javascript:if(confirm('确实要删除吗?'))location='admin_comment.php?action=Del&id=<?php echo $value['CID'] ?>'">删除</a></span>
								<?php }else{ ?>
									<span class="Control"><img src="../Include/edt.gif" width="16" height="16" /><a href="admin_comment.php?action=OK&id=<?php echo $value['CID'] ?>">通过</a>&nbsp; &nbsp;<img src="../Include/del.gif" width="16" height="16" /><a href="javascript:if(confirm('确实要删除吗?'))location='admin_comment.php?action=Del&id=<?php echo $value['CID'] ?>'">删除</a></span>
								<?php } ?>
								</td>
							</tr>
							<?php
								$i ++;
							}
							?>
						<tbody>
					</table>
				</div>
				<?php if( $action == 'list' ) { ?>
					<div align="center">批量管理选项: <input type="radio" name="Control" value="删除" checked="checked"/>删除 <input type="submit" name="Submit" class="Main_Button" value="执行操作" /></div>
				<?php }else{ ?>
					<div align="center">批量管理选项: <input type="radio" name="Control" value="通过" checked="checked"/>通过 <input type="radio" name="Control" value="删除"/>删除 <input type="submit" name="Submit" class="Main_Button" value="执行操作" /></div>
				<?php } ?>
			</form>
<?php
}

function batch() {
	global $db,$_CACHE;
	$id_arr = array();
	$id_arr = getGP( 'id_arr','P','array' );
	$control = getGP( 'Control','P' );
	$size = count( $id_arr );
	if( $size == 0 ) {
		obclean();
		show_admin_message( '您没有选中任何评论', 'admin_comment.php?action=Comment' );
		exit;
	}
	$sql = '';
	for( $i=0; $i<$size; $i ++ ){
		$sql .= 'CID=' . $id_arr[$i] . ' OR ';
	}
	$sql = substr( $sql,0,-4 );
	$comment_array = $db->fetch_all( 'select CID,Author,Time,Comment,Reply,ReplyTime from `' . PREFIX_STR . 'Comment` where (' . $sql . ') order by CID desc' );
?>
			<div style="padding:5px;margin:2px;">      
				<table style="table-layout: fixed;word-wrap: break-word;" width="100%" border="0" cellpadding="0" cellspacing="1" bgcolor="b5d6e6" onmouseover="changeto()"  onmouseout="changeback()">
					<tr align="center" height="22" bgcolor="#ffffff">
						<td width="3%"  background="../Include/bg.gif"></td>
						<td width="3%"  background="../Include/bg.gif">序号</td>
						<td width="10%" background="../Include/bg.gif">作者</td>
						<td width="31%" background="../Include/bg.gif">内容</td>
						<td width="9%" background="../Include/bg.gif">时间</td>
						<td width="22%" background="../Include/bg.gif">回复</td>
						<td width="9%" background="../Include/bg.gif">回复时间</td>
						<td width="13%" background="../Include/bg.gif">管理操作</td>
					</tr>
					<?php
					$i = 1;
					foreach( $comment_array as $value ) {
					?>
					<tr align="center" height="20" bgcolor="#ffffff">
						<td ></td>
						<td><?php echo $i ?></td>
						<td><?php echo $value['Author'] ?></td>
						<td align="left"><?php echo $value['Comment'] ?></td>
						<td><?php echo date( 'Y-m-d', $value['Time'] ) ?></td>
						<td align="left"><?php echo $value['Reply'] ?></td>
						<td><?php if( $value['Reply'] != '' ) echo date( 'Y-m-d', $value['ReplyTime'] ); ?>
						</td>
						<td></td>
					</tr>
					<?php
						$i ++;
					}
					?>
				</table>
			</div>
			<div style="padding:5px;margin:2px;">
				<form name="smslist" action="admin_comment.php?action=BatchExe" method="post">
					<input type="hidden" name="SQL" value="<?php echo $sql ?>"/>
<?php
	if( $control == '删除' ) {
?>
					<input type="hidden" name="Control" value="删除"/>
					<input type="submit" name="submit" class="Main_Button" value="确认删除" />
<?php
	}else{
?>
					<input type="hidden" name="Control" value="通过"/>
					<br /><input type="submit" name="submit" class="Main_Button" value="确认通过" />
<?php
	}
?>
				</form>
			</div>
<?php
}

function main() {
?>
		<div style="padding:10px;">
			欢迎进行 <b>评论与留言管理</b>，方便您批量处理评论与留言。
		</div>
<?php
}
?>
		</div>
	</div>
	<div id="Foot"><?php show_run_info() ?></div>
</center>
</div>
</body>
</html>